from manifest_edit.plugin.mpd import BasePlugin
from schema import Schema, Or


class Plugin(BasePlugin):
    '''A plugin that can create a configuration for supplemental_property_add.

    In this case the destination plugin needs to receive both a configuration
    and an element of the manifest to which to apply it. In this case the
    element must be a representation.

    '''

    _name = __name__

    _keys = ['destination', 'plugin_config']

    def schema(self):
        return Schema(
            {
                self._keys[0]: str,
                self._keys[1]: Or(dict, list)
            }
        )

    # This is the only format supported for the moment
    def process(self, manifest, storage):
        storage.update(
            {self.config(storage=storage)[self._keys[0]]:
             [
                (
                    self.config(storage=storage)[self._keys[1]],
                    manifest.periods[0].adaptationSets[0].representations[0]
                )
            ]
            }
        )
